*! version 5.0
* 13 August 2018
* NIDS
* Master Income do file for Nids Wave 1

* THIS IS 5th INCOME DO FILE - PRE-IMPUTATION AGGREGATION DO FILE: 5 OF 7
* THIS DO FILE AGGREGATES THE PRE-IMPUTATION INCOME VARIABLES

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "W1 Income do file (1 of 7)"

version 12.0

*=====================================================================================================================================

* OPENING DATASET PREPARED IN DO FILE "Income - Preparing variables for imputation (3 of 7).DO"

set more off

use "$DataOUT\prepdata.dta", clear

*-------------------------------------------------------------------------------------------------------------------------------------

* AGGREGATING WITHOUT IMPUTATION

*Total labour market income for smooth
egen pi_labourincome=rowtotal(fwag cwag swag cheq bonu help prof extr)
replace pi_labourincome=. if pi_labourincome==0
gen lnpi_labourincome=ln(pi_labourincome)

*Government income (excluding state old-age pension)
egen pi_governmentincome=rowtotal(spen dis chld fost care)
replace pi_governmentincome=. if pi_governmentincome==0
gen lnpi_governmentincome=ln(pi_governmentincome)

*Other government income
egen pi_otherincome=rowtotal(uif comp)
replace pi_otherincome=. if pi_otherincome==0
gen lnpi_otherincome=ln(pi_otherincome)

*Investment income from stocks, loans, rentals, private pensions, retirement annuities...
egen pi_investmentincome=rowtotal(indi rnt ppen)
replace pi_investmentincome=. if pi_investmentincome==0
gen lnpi_investmentincome=ln(pi_investmentincome)

*Income of a capital nature
egen pi_capitalincome=rowtotal(inhe retr brid gift loan sale othe)
replace pi_capitalincome=. if pi_capitalincome==0
gen lnpi_capitalincome=ln(pi_capitalincome)

*Remittances
gen pi_remittanceincome=remt
gen lnpi_remittanceincome=ln(pi_remittanceincome)

*household level income categories
egen pi_hhwage=sum(pi_labourincome), by(w1_hhid)
replace pi_hhwage=. if pi_hhwage==0
label variable pi_hhwage "Household monthly income from labour market, no imputations"
egen pi_hhgovt=sum(pi_governmentincome), by(w1_hhid)
replace pi_hhgovt=. if pi_hhgovt==0
label variable pi_hhgovt "Household monthly income from government grants, no imputations"
egen pi_hhother=sum(pi_otherincome), by(w1_hhid)
replace pi_hhother=. if pi_hhother==0
label variable pi_hhother "Household monthly income from other government sources, no imputations"
egen pi_hhinvest=sum(pi_investmentincome), by(w1_hhid)
replace pi_hhinvest=. if pi_hhinvest==0
label variable pi_hhinvest "Household monthly income from investments, no imputations"
egen pi_hhcapital=sum(pi_capitalincome), by(w1_hhid)
replace pi_hhcapital=. if pi_hhcapital==0
label variable pi_hhcapital "Household monthly income of a capital nature, no imputations"
egen pi_hhremitt=sum(pi_remittanceincome), by(w1_hhid)
replace pi_hhremitt=. if pi_hhremitt==0
label variable pi_hhremitt "Household monthly income from remittances, no imputations"
rename hhagric pi_hhagric
label variable pi_hhagric "Household average monthly income from subsistence agriculture, no imputations"

*Household total income with zero imputation
egen pi_hhincome=rowtotal(pi_hhwage pi_hhgovt pi_hhother pi_hhinvest pi_hhremitt pi_hhagric)
replace pi_hhincome=. if pi_hhincome==0
label variable pi_hhincome "Household monthly income - no imputations"

keep pid pi_*
sort pid
save "$DataOUT\pi_data.dta", replace

*-------------------------------------------------------------------------------------------------------------------------------------

* OPENING DATASET CREATED IN PREVIOUS DO FILE "Program 7.3 - Income -  Performing Imputations for missing data on Income varaibles (4 of 7)"

use "$DataOUT\impdata.dta", clear
sort pid
merge m:m pid using "$DataOUT\pi_data.dta"
drop _merge
save "$DataOUT\impdata.dta", replace
erase "$DataOUT\pi_data.dta"

* end of do file
*=====================================================================================================================================
